﻿$IntuneDeployScriptDir = "C:\ProgramData\IntuneDeployedScripts"
if(!(Test-Path $IntuneDeployScriptDir)){
    New-Item -ItemType Directory -Path $IntuneDeployScriptDir -Force
}

Function Log-Message{
    param (
        [string]$message,
        [string]$Logfile = "C:\ProgramData\IntuneDeployedScripts\DTBC-0077_STIG.log"   
    )
    $Timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    "$Timestamp - $message" | Out-File -FilePath $Logfile -Append
}

$GoogleChromeRegPath = "HKLM:\Software\Policies\Google\Chrome"
$GenAILocalFoundationalModelSettingsKey = "GenAILocalFoundationalModelSettings"
$GenAILocalFoundationalModelSettingsValue = 1
if(!(Test-Path $GoogleChromeRegPath)){
    Log-Message -message "$GoogleChromeRegPath registry path not found"
    New-Item -Path $GoogleChromeRegPath -Force | Out-Null
    Log-Message -message "$GoogleChromeRegPath registry path created"
    New-ItemProperty -Path $GoogleChromeRegPath -Name $GenAILocalFoundationalModelSettingsKey -Value $GenAILocalFoundationalModelSettingsValue -PropertyType DWORD -Force | Out-Null
    Log-Message -message "$GenAILocalFoundationalModelSettingsKey registry key created value $GenAILocalFoundationalModelSettingsValue "
} else {
    Log-Message -message "Checking value of $GenAILocalFoundationalModelSettingsKey registry key expecting $GenAILocalFoundationalModelSettingsValue"
    Try {
        $GenAILocalFoundationalModelSettingsCheck = Get-ItemPropertyValue -Path $GoogleChromeRegPath -Name $GenAILocalFoundationalModelSettingsKey
        if($GenAILocalFoundationalModelSettingsCheck -ne $GenAILocalFoundationalModelSettingsValue){
            Log-Message -message "$GenAILocalFoundationalModelSettingsKey configured incorrect value: $GenAILocalFoundationalModelSettingsCheck"
            New-ItemProperty -Path $GoogleChromeRegPath -Name $GenAILocalFoundationalModelSettingsKey -Value $GenAILocalFoundationalModelSettingsValue -PropertyType DWORD -Force | Out-Null
            Log-Message -message "Set $GenAILocalFoundationalModelSettingsKey value: $GenAILocalFoundationalModelSettingsValue"

        } else {
            Log-Message -message "$GenAILocalFoundationalModelSettingsKey properly configued. No changes needed"
        }
    } Catch {
        Log-Message -message "The property does not exist or an error occurred: $_"
        New-ItemProperty -Path $GoogleChromeRegPath -Name $GenAILocalFoundationalModelSettingsKey -Value $GenAILocalFoundationalModelSettingsValue -PropertyType DWORD -Force | Out-Null
        Log-Message -message "Set $GenAILocalFoundationalModelSettingsKey value: $GenAILocalFoundationalModelSettingsValue"
    }
}